define(['angular', 'app'], function (angular, app) {
    "use strict";
    app.service('TrackersRemindersService', function ($q, TrackersRemindersInstanceService, NotificationsPreferencesService, $state, $filter) {

        var TrackersRemindersService = {},
            remindersService,
            key,
            section;

        TrackersRemindersService.init = function(instanceKey) {
            remindersService = TrackersRemindersInstanceService.instance(instanceKey + '-reminders');
            key = instanceKey;
            section = $filter('filter')($state.current.data.paramSections, { paramValue: key }, true)[0].sectionName;
        };

        TrackersRemindersService.getReminder = function(name) {
            var defer = $q.defer();

            remindersService.fetch().then(function(response) {
                if (response.size === 0) {
                    defer.resolve(remindersService.createEmpty());
                } else {
                    defer.resolve(response.reminders[0]);
                }
            }, function(error) {
                defer.reject(error);
            });

            return defer.promise;
        };

        TrackersRemindersService.save = function(reminder) {
            reminder.title = 'Update your ' + section + ' Tracker now.';
            if (reminder.notificationStatus === 'On') {
                reminder.healthTrackerId = key;
                reminder.emailSignature = 'VA FitHeart - Health';
                reminder.auxData = createReminderAuxData();

                // updates stemming from DCKDA-1519 to reflect new email body content expected by Notification Services
                reminder.subject = reminder.auxData[0].value;
                reminder.messageBody = reminder.auxData[4].value;
            }

            var defer = $q.defer();

            remindersService.save(reminder).then(function() {
                defer.resolve();
            }, function(error){
                defer.reject(error);
            });

            return defer.promise;
        };

        function createReminderAuxData() {
            var preferencesData = NotificationsPreferencesService.dataPointers.notificationPreference;

            var addressee = preferencesData.firstName + ' ' + preferencesData.lastName,
                subject = 'Update your ' + section + ' Tracker now.',
                initialBodymessage = '<br/>This notice is provided to help you remember to update your ' + section + ' Tracker.<br/><br/>',
                appLink = window.location.host + window.location.pathname,
                appName = 'fit-heart',
                linkElement = '<a href="" + appLink + "">' + appName + '</a>',
                updateBodyMessage = 'Update this Health entry in the' + linkElement + '<br/><br/>' + 'To stop future notices, edit the notification settings inside the Health feature within the VA FitHeart App.<br/><br/>',
                emailSignature = 'VA FitHeart - Health';

            var fullMessageBody = addressee + '<br/><br/>' + subject + initialBodymessage + updateBodyMessage + emailSignature;


            return [
                {key: 'emailSubject', value: subject},
                {key: 'emailBody', value: initialBodymessage},
                {key: 'emailUpdateMessage', value: updateBodyMessage},
                {key: 'messageBody', value: fullMessageBody},
                {key: 'emailSignature', value: 'VA FitHeart - Health'},
                {key: 'source', value: 'FIT_HEART'},
                {key: 'appName', value:  'fit-heart'},
                {key: 'appUri', value: 'fit-heart'}
            ];
        }

        return TrackersRemindersService;
    });
});
